
const ActionParameterType = Object.freeze({
	"None"				:0,
	"FilePath"			:1,
	"String"			:2,
	"IntegerNumber"		:3,
	"DoubleNumber"		:4,
	"MultipleValues"	:5,
	"Blob"				:6
});

function ActionParameter(object) {
	this.type = ActionParameterType.None;
	this.default_value = undefined;
	this.minimum_value = undefined;
	this.maximum_value = undefined;
	this.possible_values = undefined;
	this.name = "";

	this.updateFrom = function(object) {
		if (object != undefined) {
			if (object.type != undefined) {
				this.type = object.type;
			}
			if (object.name != undefined) {
				this.name = object.name;
			}
			if (object.default_value != undefined) {
				this.default_value = object.default_value;
			}
			if (object.minimum_value != undefined) {
				this.minimum_value = object.minimum_value;
			}
			if (object.maximum_value != undefined) {
				this.maximum_value = object.maximum_value;
			}
			if (object.possible_values != undefined) {
				this.possible_values = object.possible_values;
			}
		}
	}

	this.updateFrom(object);
}

function ActionTemplate(object) {
	this.unique_id = "";
	this.name = "";
	this.group_name = "";
	this.parameters = [];
	this.is_available = true;

	this.updateFrom = function(object) {
		if (object != undefined) {
			if (object.unique_id != undefined) {
				this.unique_id = object.unique_id;
			}
			if (object.name != undefined) {
				this.name = object.name;
			}
			if (object.group_name != undefined) {
				this.group_name = object.group_name;
			}
			if (object.is_available != undefined) {
				this.is_available = object.is_available;
			}
			if (object.parameters != undefined) {
				this.parameters = [];
				for (var i = 0; i < object.parameters.length; i++) {
					const po = object.parameters[i];

					const parameter = new ActionParameter(po);
					this.parameters.push(parameter);
				}
			}
		}
	}


	this.hasParameters = function() {
		return this.parameters.length > 0;
	}

	this.updateFrom(object);
}
